% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCor.R
\name{plotCor}
\alias{plotCor}
\title{Graphical output for the asmbPLS-DA framework}
\usage{
plotCor(
  fit.results,
  ncomp = 1,
  block.name = NULL,
  group.name = NULL,
  legend = TRUE
)
}
\arguments{
\item{fit.results}{The output of \code{\link[asmbPLS]{asmbPLSDA.fit}}.}

\item{ncomp}{Which component to plot from each block. Should not be larger 
than the number of PLS components used (\code{PLS.comp}) in the function
\code{\link[asmbPLS]{asmbPLSDA.fit}}. The default is 1.}

\item{block.name}{A vector containing the named character for each block. It
must be ordered and match each block.}

\item{group.name}{A vector containing the named character for each sample 
group. For \code{binary} outcome, first group name matches \code{Y.matrix} = 0, 
second group name matches \code{Y.matrix} = 1. For \code{multiclass} outcome,
 \code{i}th group name matches \code{i}th column of \code{Y.matrix} = 1.}

\item{legend}{A logical value indicating whether the legend should be added.
The default is TRUE.}
}
\value{
none
}
\description{
Function to visualize correlations between PLS components from different blocks 
using the model fitted by the function \code{\link[asmbPLS]{asmbPLSDA.fit}}.
}
\details{
The function returns a plot to show correlations between PLS components from 
different blocks. The lower triangular panel indicates Pearson's 
correlation coefficient, and the upper triangular panel the scatter plot.
}
\examples{
## Use the example dataset
data(asmbPLSDA.example)
X.matrix = asmbPLSDA.example$X.matrix
Y.matrix.binary = asmbPLSDA.example$Y.matrix.binary
Y.matrix.multiclass = asmbPLSDA.example$Y.matrix.morethan2levels
X.dim = asmbPLSDA.example$X.dim
PLS.comp = asmbPLSDA.example$PLS.comp
quantile.comb = asmbPLSDA.example$quantile.comb
 
## asmbPLSDA fit for binary outcome
asmbPLSDA.fit.binary <- asmbPLSDA.fit(X.matrix = X.matrix, 
                                      Y.matrix = Y.matrix.binary, 
                                      PLS.comp = PLS.comp, 
                                      X.dim = X.dim, 
                                      quantile.comb = quantile.comb,
                                      outcome.type = "binary")

## asmbPLSDA fit for categorical outcome with more than 2 levels
asmbPLSDA.fit.multiclass <- asmbPLSDA.fit(X.matrix = X.matrix, 
                                          Y.matrix = Y.matrix.multiclass,
                                          PLS.comp = PLS.comp, 
                                          X.dim = X.dim, 
                                          quantile.comb = quantile.comb,
                                          outcome.type = "multiclass")

## visualization with default block.name and group.name using the first PLS component 
plotCor(asmbPLSDA.fit.binary, 1)
plotCor(asmbPLSDA.fit.multiclass, 1)
## custom block.name and group.name
plotCor(asmbPLSDA.fit.binary, 
        ncomp = 1, 
        block.name = c("mRNA", "protein"), 
        group.name = c("control", "case"))
plotCor(asmbPLSDA.fit.multiclass, 
        ncomp = 1, 
        block.name = c("mRNA", "protein"), 
        group.name = c("healthy", "mild", "severe"))


}
