% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_aic_fit_1d.R
\name{get_aic_fit_1d}
\alias{get_aic_fit_1d}
\title{Return the AIC of 1ts model}
\usage{
get_aic_fit_1d(
  lrho,
  r,
  y,
  Z = NULL,
  Bs,
  Ds,
  Wprior = NULL,
  control_algorithm = list(maxiter = 20, conv_crit = 1e-05, verbose = FALSE, monitor_ev =
    FALSE)
)
}
\arguments{
\item{lrho}{A starting value for \eqn{\log_{10}(\varrho_s)}. Default is 0.}

\item{r}{A vector of exposure times of length ns, or an array of dimension ns
by n.}

\item{y}{A vector of event counts of length ns, or an array of dimension ns
by n.}

\item{Z}{(optional) A regression matrix of covariates of dimension n by p.}

\item{Bs}{A matrix of B-splines for the time scale \code{s}.}

\item{Ds}{The difference matrix of the penalty.}

\item{Wprior}{An optional vector of a-priori weights.}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
\item \code{monitor_ev} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the
evaluation of the model over the \code{log_10(rho_s)} values.
}}
}
\value{
The \code{aic} value of the fitted model.
}
\description{
\code{get_aic_fit_1d()} fits the 1ts model with or without individual
level covariates and it returns the AIC of the model.
See also \code{fit1tsmodel_ucminf()} and \code{fit1ts()}.
}
