% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit1tsmodel_ucminf.R
\name{fit1tsmodel_ucminf}
\alias{fit1tsmodel_ucminf}
\title{Numerical optimization of the 1ts model}
\usage{
fit1tsmodel_ucminf(
  r,
  y,
  Z = NULL,
  lrho = 0,
  Bs,
  Ds,
  Wprior = NULL,
  optim_criterion = c("aic", "bic"),
  control_algorithm = list()
)
}
\arguments{
\item{r}{A vector of exposure times of length ns, or an array of dimension ns
by n.}

\item{y}{A vector of event counts of length ns, or an array of dimension ns
by n.}

\item{Z}{(optional) A regression matrix of covariates of dimension n by p.}

\item{lrho}{A starting value for \eqn{\log_{10}(\varrho_s)}. Default is 0.}

\item{Bs}{A matrix of B-splines for the time scale \code{s}.}

\item{Ds}{The difference matrix of the penalty.}

\item{Wprior}{An optional vector of a-priori weights.}

\item{optim_criterion}{The criterion to be used for optimization:
\code{"aic"} (default) or \code{"bic"}.}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
\item \code{monitor_ev} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the
evaluation of the model over the \code{log_10(rho_s)} values.
}}
}
\value{
An object of class \code{haz1ts} with the following elements:
\itemize{
\item \code{optimal_model} A list containing the results of the optimal model.
\item \code{optimal_logrho} The optimal value of \code{log10(rho_s)}.
\item \code{P_optimal} The optimal penalty matrix P.
}
}
\description{
\code{fit1tsmodel_ucminf()} performs a numerical optimization of the
AIC or BIC of the one time scale model.

It finds the optimal values of \eqn{\log_{10}(\varrho_s)} and returns the estimated
optimal model.
See also \code{\link[ucminf:ucminf]{ucminf::ucminf()}}.
}
\references{
Nielsen H, Mortensen S (2024).
\emph{ucminf: General-Purpose Unconstrained Non-Linear Optimization}.
R package version 1.2.2, \url{https://CRAN.R-project.org/package=ucminf}
}
