% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposures_events_2d.R
\name{exposures_events_2d}
\alias{exposures_events_2d}
\title{Bin data on two time scales}
\usage{
exposures_events_2d(u, s_in = NULL, s_out, ev, bins_list, individual = FALSE)
}
\arguments{
\item{u}{A vector of fixed times at entry in the process, measured over the
first time scale.}

\item{s_in}{A vector of (possibly left truncated) times at entry. If this is
not provided by the user, the function will consider a value of 0 for all
observations.}

\item{s_out}{A vector of times at event or censoring.}

\item{ev}{A vector of events' indicators (possible values 0/1).}

\item{bins_list}{is a list with the following (necessary) elements
(usually prepared by \code{\link[=make_bins]{make_bins()}}):
\itemize{
\item \code{bins_u} a vector of extreme values for the bins over the \code{u} axis
\item \code{bins_s} a vector of extreme values for the bins over the \code{s} axis
}}

\item{individual}{A Boolean. Default is \code{FALSE}: if \code{FALSE} computes the matrices
R and Y collectively for all observations; if \code{TRUE} computes the matrices
R and Y separately for each individual record.}
}
\value{
A list with the following elements:
\itemize{
\item \code{R} an array of exposure times: if \code{individual == TRUE},
then \code{R} is an array of dimension \eqn{nu} by \eqn{ns} by \eqn{n},
otherwise is an array of dimension \eqn{nu} by \eqn{ns}
\item \code{Y}an array of event counts: if \code{individual == TRUE},
then \code{Y} is an array of
dimension \eqn{nu} by \eqn{ns} by \eqn{n}, otherwise is an array of
dimension \eqn{nu} by \eqn{ns}
}
}
\description{
\code{exposures_events_2d()} computes individual or aggregated
matrices of exposure times and event counts starting from individual
records of time at entry in the process (measured over the first time
scale), duration at entry in the process (measured over the second time
scale), duration at exit from the process (measured over the second time
scale), and event's indicator.
}
\details{
The fixed-time variable \code{u} and the second time scale \code{s}
are divided into \eqn{nu} and \eqn{ns} intervals, respectively. The extremes of these
intervals are provided as input to the function. First, the fixed-time at
entry is located in one of the nu bins that cover the whole range of
\code{u}. Then, the time-at-risk for each individual is split according to
the \eqn{ns} bins that span the whole range of values for \code{s}, and an event
indicator is placed in the bin where the exit time is located. This is done
by calling the function \code{exposure_events_1d}. If individual matrices of
exposure and events are required, then the function returns two arrays of
dimension \eqn{nu} by \eqn{ns} by \eqn{n}. If aggregated results are preferred, the
individual contributions are summed in each bin to provide a matrix of
total exposure time and a matrix of total event counts, both of dimensions
\eqn{nu} by \eqn{ns}. See also \code{\link[=prepare_data]{prepare_data()}} to conveniently prepare individual data
for the analysis with one, or two time scales.
}
\examples{
# ---- Bin colon cancer data by time at randomization and time since recurrence ----
# First create vectors of bins (using function `make_bins()`)
bins <- make_bins(u = reccolon2ts$timer, s_out = reccolon2ts$timesr,
du = 30, ds = 30)
# Now bin data (note: the s_in argument is omitted because data are not left truncated)
bindata2d <- exposures_events_2d(u = reccolon2ts$timer,
s_out = reccolon2ts$timesr, ev = reccolon2ts$status, bins = bins)

}
\author{
Angela Carollo \email{carollo@demogr.mpg.de}
}
