% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{dRDTS}
\alias{dRDTS}
\title{Density function of the rapidly decreasing tempered stable (CTS) distribution}
\usage{
dRDTS(
  x,
  alpha = NULL,
  delta = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  dens_method = "FFT",
  a = -20,
  b = 20,
  nf = 256
)
}
\arguments{
\item{x}{A numeric vector of quantiles.}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{delta}{Scale parameter for the left tail. A real number > 0.}

\item{lambdap}{Tempering parameter for the right tail. A real number > 0.}

\item{lambdam}{Tempering parameter for the left tail. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{dens_method}{Algorithm for numerical evaluation. Choose \code{
"FFT"}.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -20
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 20
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size. 256 by default.}
}
\value{
As \code{x} is a numeric vector, the return value is also a numeric
vector of densities.
}
\description{
The probability density function (PDF) of the rapidly decreasing tempered
stable distributions is not available in closed form.
Relies on fast Fourier transform (FFT) applied to the characteristic
function.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, delta,
lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}. Methods include only the the Fast Fourier Transform
(FFT).

For examples, compare with \code{\link[=dCTS]{dCTS()}}.
}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'
}
