% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trop.determinant.R
\name{tdets}
\alias{tdets}
\title{Calculate the tropical determinant of a square matrix.}
\usage{
tdets(P, tadd = max)
}
\arguments{
\item{P}{matrix of points defining a tropical polytope. Rows are the points}

\item{tadd}{function; max indicates max-plus addition, min indicates
min-plus addition. Defaults to max}
}
\value{
list containing the value of the determinant and reordered matrix P
}
\description{
This function calculates the tropical determinant (or singularity) of a
square matrix
}
\examples{
P<-matrix(c(0,0,0,0,2,5,0,3,1),3,3,TRUE)
tdets(P)
tdets(P,tadd=min)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
