library(testthat)
test_that("Genotypic_Path returns expected structure and values", {
  # Use the provided mock data
  mock_data <- data.frame(
    Replication = rep(c("R1", "R2", "R3"), times = 10),
    Genotype = rep(paste0("G", 1:10), each = 3),
    DBH = c(12.39, 13.02, 12.51, 16.3, 16.13, 18.51, 14.09, 13.95, 12.63, 14.55, 13.29, 14.13,
            14.36, 14.5, 15.09, 10.39, 11.13, 10.28, 12.67, 13.58, 12.54, 17.15, 18.38, 16.98,
            10.08, 10.8, 9.98, 13.61, 14.58, 13.47),
    PH = c(107.04, 103.98, 94.8, 108.71, 122.44, 112.14, 80.87, 72.32, 80.09, 103.05, 87.5, 101.11,
           70.85, 72.32, 78.23, 76.9, 84.83, 76.11, 67.36, 70.8, 68.05, 112.8, 111.63, 128.08,
           85.18, 84.37, 76.34, 102.52, 93.65, 99.57),
    FW = c(64.83, 59.22, 62.96, 128.17, 129.48, 134.71, 62.33, 66.78, 61.69, 90.5, 96.97, 89.58,
           43.08, 46.16, 42.64, 48.8, 52.29, 48.31, 61.72, 66.13, 61.09, 126.55, 129.06, 120.29,
           61.05, 64.17, 61.68, 81.17, 86.97, 80.35),
    SW = c(25.96, 25.21, 22.99, 24.99, 28.14, 25.77, 28.37, 25.37, 28.1, 28.26, 23.99, 27.73,
           24.45, 24.96, 27, 26.66, 29.4, 26.38, 26.55, 27.9, 26.82, 28.46, 28.17, 32.32,
           30.91, 30.62, 27.7, 26.27, 24, 25.51),
    KW = c(16.8, 15.34, 16.31, 15.74, 15.9, 16.54, 17.85, 19.12, 17.66, 15.89, 17.02, 15.72,
           16.36, 17.52, 16.19, 15.52, 16.63, 15.36, 17.26, 18.49, 17.08, 17.87, 18.22, 16.98,
           17.17, 18.05, 17.34, 15.07, 16.15, 14.92)
  )

  # Run the function
  result <- Genotypic_Path(mock_data)

  # Check the output structure
  expect_type(result, "list")


})
