% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rao.diversity.R
\encoding{UTF-8}
\name{rao.diversity}
\alias{rao.diversity}
\title{Rao's quadratic entropy}
\usage{
rao.diversity(
  comm,
  traits = NULL,
  phylodist = NULL,
  checkdata = TRUE,
  ord = "metric",
  put.together = NULL,
  standardize = TRUE,
  transformation = "standardized",
  spp.weights = NULL,
  ...
)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as
rows. This matrix can contain either presence/absence or abundance data.
Alternatively comm can be an object of class metacommunity.data, an alternative
way to set all data.frames/matrices. When you use the class metacommunity.data the arguments
traits, phylodist and put.together must be null. See details.}

\item{traits}{Data frame or matrix data of species described by traits, with traits as
columns and species as rows (Default traits = NULL).}

\item{phylodist}{Matrix containing phylogenetic distance between species
(Default phylodist = NULL).}

\item{checkdata}{Logical argument (TRUE or FALSE) to check if species
sequence in the community data follows the same order as the one in the
trait and in the phylodist matrices (Default checkdata = TRUE).}

\item{ord}{Method to be used for ordinal variables, see \code{\link[FD]{gowdis}}
(Default ord = "metric").}

\item{put.together}{List to specify group of traits. Each group specify receive the
same weight that one trait outside any group, in the way each group is considered
as unique trait (Default put.together = NULL). This argument must be a list, see
examples in \code{\link{syncsa}}.}

\item{standardize}{Logical argument (TRUE or FALSE) to specify if standardize phylogenetic
distance to range into range 0 to 1. (Default standardize = TRUE).}

\item{transformation}{Method to transformation, "none", "standardized", "weights"
or "max.weights" (Default transformation = "standardized").}

\item{spp.weights}{Vector with 0 or 1 to specify individual species weights (Default spp.weights = NULL).}

\item{...}{Parameters for \code{\link[FD]{gowdis}} function.}
}
\value{
\item{Simpson}{Gini-Simpson index within each community (equivalent
to Rao quadratic entropy with null, crisp, similarities).}
\item{FunRao}{Rao quadratic entropy within each community, considering trait distance.}
\item{FunRedundancy}{Functional redundancy in each community.}
\item{PhyRao}{Rao quadratic entropy within each community, considering phylogenetic distance.}
\item{PhyRedundancy}{Phylogenetic redundancy in each community.}
}
\description{
Calculates Rao's quadratic entropy, functional and phylogenetic redundancy.
}
\details{
Rao's quadratic entropy is a measure of diversity of ecological communities
defined by Rao (1982) and is based on the proportion of the abundance of
species present in a community and some measure of dissimilarity among them.
The dissimilarity range from 0 to 1 and is based on a set of specified
functional traits or in the phylogenetic dissimilarity.

For the trait data, the function calculates the square root of the
one-complement of Gower`s similarity index, in order to have a dissimilarity
matrix with Euclidean metric properties. Gower`s index ranges from 0 to 1
and can handle traits measured indifferent scales. When the species are
completely different in terms of their traits, Rao quadratic entropy is
equivalent to the Gini-Simpson index. Traits data can be numeric, factor or
ordered factor. For this be considered traits data must be of data.frame
class and containing each variable type determined. For additional details and
requirements of function please see \code{\link[FD]{gowdis}}.

Functional redundancy is defined purely as the difference between species
diversity and Rao`s quadratic entropy based on their functional
dissimilarity (de Bello et al. 2007). The same definition is used for
phylogenetic redundancy.

By default, the community data is standardization to row totals will be 1.
The options are: "none" no transformation is applied; "standardized" the
community data is standardized to row totals will be 1; and "weights" community
data is first "standardized" and when, individual species weights are multiplied
to each species entries. The argument transformation also allow an additional
method to weights individual species, called "max.weights". In this method
community data is standardization as default, however dissimilarity matrix is
weighted indeed. The argument spp.weights specify the weights to target species
and the dissimilarity weights are 1 if at least one species in the pair belongs
to the target community, otherwise weights to pair are 0.

Package \strong{SYNCSA} requires that the species and community sequence in
the data.frame or matrix must be the same for all dataframe/matrices.
The function \code{\link{organize.syncsa}} organizes the data for the functions
of the package, placing the matrices of community, traits, phylogenetic distance
in the same order. The function use of function organize.syncsa is not requered
for run the functions, but is recommended. In this way the arguments comm, traits,
phylodist, as well as the argument put.together and spp.weights, can be specified them as normal
arguments or by passing them with the object returned by the function
\code{\link{organize.syncsa}} using, in this case only the argument comm.
Using the object returned by organize.syncsa, the comm argument is used as an alternative
way of entering to set all data.frames/matrices, and therefore the other arguments
(traits, phylodist, put.together and spp.weights) must be null.
}
\note{
\strong{IMPORTANT}: The sequence species show up in community data
matrix MUST be the same as they show up in traits and phylodist matrices as well as
in the species weights vector. See details and \code{\link{organize.syncsa}}.
}
\examples{
data(ADRS)
rao.diversity(ADRS$community)
rao.diversity(ADRS$community, traits = ADRS$traits)
}
\references{
de Bello, F.; Leps, J.; Lavorel, S. & Moretti, M. (2007).
Importance of species abundance for assessment of trait composition: an
example based on pollinator communities. Community Ecology, 8, 163:170.

Pillar, V.D.; Blanco, C.C.; Muler, S.C.; Sosinski, E.E.; Joner, F. & Duarte,
L.d.S. (2013). Functional redundancy and stability in plant communities.
Journal of Vegetation Science, 24, 963:974.

Rao, C.R. (1982). Diversity and dissimilarity coefficients: a unified
approach. Theoretical Population Biology, 21, 24:43.
}
\seealso{
\code{\link{organize.syncsa}}, \code{\link[FD]{gowdis}},
\code{\link{syncsa}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
