% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress_mean.R
\name{stress_mean_w}
\alias{stress_mean_w}
\title{Stressing Mean}
\usage{
stress_mean_w(
  x,
  new_means,
  k = 1,
  h = 1,
  names = NULL,
  log = FALSE,
  method = "Nelder-Mead",
  ...
)
}
\arguments{
\item{x}{A vector, matrix or data frame
containing realisations of random variables. Columns of \code{x}
correspond to random variables; OR\cr
A \code{SWIMw} object, where \code{x} corresponds to the
underlying data of the \code{SWIMw} object. The stressed random component is assumed continuously distributed.}

\item{new_means}{Numeric, the stressed mean.\cr}

\item{k}{Numeric, the column of \code{x} that is stressed
\code{(default = 1)}.\cr}

\item{h}{Numeric, a multiplier of the default bandwidth using Silverman’s rule (default \code{h = 1}).\cr}

\item{names}{Character vector, the names of stressed models.}

\item{log}{Boolean, the option to print weights' statistics.}

\item{method}{The method to be used in [stats::optim()]. (\code{default = Nelder-Mead}).}

\item{...}{Additional arguments to be passed to
\code{\link[nleqslv]{nleqslv}}.}
}
\value{
A \code{SWIMw} object containing:
    \itemize{
      \item \code{x}, a data.frame containing the data;
      \item \code{h}, h is a multiple of the Silverman’s rule;
      \item \code{u}, vector containing the gridspace on [0, 1];
      \item \code{lam}, vector containing the lambda's of the optimized model;
      \item \code{str_fY}, function defining the densities of the stressed component;
      \item \code{str_FY}, function defining the distribution of the stressed component;
      \item \code{str_FY_inv}, function defining the quantiles of the stressed component;
      \item \code{gamma}, function defining the risk measure;
      \item \code{new_weights}, a list of functions, that applied to
  the \code{k}th column of \code{x}, generates the vectors of scenario
  weights. Each component corresponds to a different stress;
     \item \code{type = "mean"};
     \item \code{specs}, a list, each component corresponds to
   a different stress and contains \code{k} and \code{new_means}.
    }
    See \code{\link{SWIM}} for details.
}
\description{
Provides weights on simulated scenarios from a baseline stochastic
    model, such that a stressed model component (random variable) fulfils a
    constraint on its mean.
    Scenario weights are
    selected by constrained minimisation of the Wasserstein distance to the
    baseline model.
}
\examples{
\dontrun{
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000),
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress_wass(type = "mean", x = x, k = 1,
  new_means=1)
  summary(res1)

## calling stress_RM_w directly
## stressing "gamma"
res2 <- stress_mean_w(x = x, 
  new_means=2.2, k = 2)
summary(res2)
}

}
\references{
\insertRef{Pesenti2019reverse}{SWIM}\cr

    \insertRef{Pesenti2020SSRN}{SWIM}\cr

    \insertRef{Pesenti2021SSRN}{SWIM}
}
\seealso{
Other stress functions: 
\code{\link{stress_HARA_RM_w}()},
\code{\link{stress_RM_mean_sd_w}()},
\code{\link{stress_RM_w}()},
\code{\link{stress_VaR_ES}()},
\code{\link{stress_VaR}()},
\code{\link{stress_mean_sd_w}()},
\code{\link{stress_mean_sd}()},
\code{\link{stress_mean}()},
\code{\link{stress_moment}()},
\code{\link{stress_prob}()},
\code{\link{stress_user}()},
\code{\link{stress_wass}()},
\code{\link{stress}()}
}
\author{
Zhuomin Mao
}
\concept{stress functions}
