% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.R
\name{cor_stressed}
\alias{cor_stressed}
\title{Correlation of a Stressed Model}
\usage{
cor_stressed(
  object,
  xCol = c(1, 2),
  wCol = "all",
  method = "Pearson",
  base = FALSE
)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{xCol}{Numeric or character vector, (names of) the columns of 
the underlying data 
of the \code{object} (\code{default = "all"}).}

\item{wCol}{Vector, the columns of the scenario weights 
of the \code{object} corresponding to different 
stresses (\code{default = "all"}).}

\item{method}{Character, one of \code{"Pearson", "Spearman", "Kendall"}. (\code{default = "Pearson"}).}

\item{base}{Logical, if \code{TRUE}, statistics under the baseline 
are also returned (\code{default = "FALSE"}).}
}
\value{
\code{cor_stressed} returns a list of correlation matrices
    corresponding to different stresses. Entries of the matrices denote 
    correlation coefficients between stressed model components specified by \code{xCol}.
}
\description{
Provides the correlation of stressed model components
    (random variable) under the scenario weights.
}
\details{
\code{cor_stressed}: The correlation coefficient of  
     stressed model components, subject to the calculated scenario weights.
}
\examples{
     
## example with a stress on VaR
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR", x = x, 
  alpha = c(0.9, 0.95), q_ratio = 1.05)
## stressed correlation
cor_stressed(res1, xCol = c(1, 2), wCol = 1, base=TRUE)

}
\seealso{
See \code{\link{var_stressed}} and \code{\link{sd_stressed}} compute
    stressed variance and standard deviations under the scenario weights, respectively.
         
    See \code{\link[stats]{cor}} for unweighted correlations between model components, while 
    \code{cor_stressed} return correlations between stressed model components
}
\author{
Kent Wu
}
