% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact.test.R
\name{exact.test}
\alias{exact.test}
\title{Exact form test}
\usage{
exact.test(
  ts,
  c,
  d,
  m = "MV",
  b_time,
  b_timese,
  mp_type,
  exact_func,
  r = 1,
  s = 1,
  upper = 10
)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{number of basis for time input}

\item{d}{number of basis for variate input}

\item{m}{the window size for the simultaneous confidence region procedure, with the default being 'MV,' which stands for the Minimum Volatility method}

\item{b_time}{type of basis for time input}

\item{b_timese}{type of basis for variate input}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{exact_func}{A list contains elements that are matrix contain exact functions, which are desired to be tested. The k-th element represents the k-th variable.
The matrix contains values of the exact function within its domain}

\item{r}{indicates number of variate}

\item{s}{s is a positive scaling factor, the default is 1}

\item{upper}{The upper bound for the variate basis domain. The default value is 10. When "algeb" or "logari" is chosen, the domain is automatically set from -upper to upper.}
}
\value{
A list whose elements are p value of exact form test. Each element in the list represents p-values in the order of variates.
}
\description{
This function employs the L2 test for the user-specific execution of exact form tests.
}
