% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateRepo.r
\name{createRepo}
\alias{createRepo}
\title{createRepo}
\usage{
createRepo(name, path, data, packages = c("here", "knitr", "rmarkdown",
  "tidyverse", "usethis"), user, organizer = user, token = "GITHUB_PAT",
  readme, ssh = TRUE)
}
\arguments{
\item{name}{Name to use for project and repo}

\item{path}{Location for the new project}

\item{data}{\link{data.frame} listing data sources. Must have at least the following columns: Local (the name the file should be on disk after downloaded), Remote (the URL of the file), Mode (the way to write to disk, either 'w' or 'wb').}

\item{packages}{Vector of packages that the user will be instructed to install.}

\item{user}{GitHub username}

\item{organizer}{Name of organizer of class. This can be in the form a a Markdown-style link.}

\item{token}{The name of the environment variable holding the GitHub access token. This can be set with \code{\link[base:Sys.setenv]{base::Sys.setenv()}}.}

\item{readme}{Path to parameterized rmarkdown document with parameters \code{className}, \code{organizer} and \code{packages}. If missing the default from the package is used.}

\item{ssh}{If \code{TRUE}, change the remote to use ssh instead of https}
}
\value{
If all operations are successful, returns \code{TRUE}
}
\description{
Creates a new project and pushes it to GitHub
}
\details{
This is designed to make a bare repo to be used for workshops. It will create a new project with a customized README and customized download file. It then pushes this to GitHub.
}
\author{
Jared P. Lander
}
