% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{limit_positions}
\alias{limit_positions}
\title{Limit per-date selections to top-K (legacy API)}
\usage{
limit_positions(
  selection_df,
  max_positions,
  ranking_signal = NULL,
  verbose = FALSE
)
}
\arguments{
\item{selection_df}{data.frame/data.table with columns: \code{Date}, then one
column per symbol; logical (preferred) or numeric (non-NA/ >0 means selected).}

\item{max_positions}{positive integer, maximum selections to keep per row.}

\item{ranking_signal}{optional data.frame/data.table, same dims & columns as
\code{selection_df}, numeric scores used to rank within the selected set.}

\item{verbose}{logical; if \code{TRUE}, prints minor diagnostics. Default \code{FALSE}.}
}
\value{
A \code{data.table} with the same columns as \code{selection_df}, where symbol
columns are logical and at most \code{max_positions} are TRUE in each row.
}
\description{
Legacy selector used across examples/vignettes. Works on a WIDE table
(\code{Date} + one column per symbol) and returns a WIDE logical mask with at
most \code{max_positions} TRUE values per row.
}
\details{
If \code{ranking_signal} is supplied, it must have \strong{the same shape} and columns
as \code{selection_df}; the function keeps the top-\code{K} (largest) scores among
the \emph{currently selected} columns in that row. If \code{ranking_signal} is \code{NULL},
it falls back to the values in \code{selection_df} (if numeric), otherwise keeps
the first \code{K} selected symbols in column order (deterministic).
}
\examples{
\donttest{
  data(sample_prices_weekly)
  mom12 <- PortfolioTesteR::calc_momentum(sample_prices_weekly, 12)  # WIDE numeric
  sel10 <- PortfolioTesteR::filter_top_n(mom12, 10)                  # WIDE logical/numeric
  # Ensure logical mask
  syms <- setdiff(names(sel10), "Date")
  sel_mask <- data.table::as.data.table(sel10)
  sel_mask[, (syms) := lapply(.SD, function(z) as.logical(as.integer(z))), .SDcols = syms]

  # Keep at most 10 per date using momentum as the ranking signal
  lim <- limit_positions(selection_df = sel_mask, max_positions = 10L,
                         ranking_signal = mom12, verbose = FALSE)
  head(lim)
}

}
