% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionalCovariates.R
\name{getCohortCovariateData}
\alias{getCohortCovariateData}
\title{Extracts covariates based on cohorts}
\usage{
getCohortCovariateData(
  connection,
  tempEmulationSchema = NULL,
  oracleTempSchema = NULL,
  cdmDatabaseSchema,
  cdmVersion = "5",
  cohortTable = "#cohort_person",
  rowIdField = "row_id",
  aggregated,
  cohortIds,
  covariateSettings,
  ...
)
}
\arguments{
\item{connection}{The database connection}

\item{tempEmulationSchema}{The schema to use for temp tables}

\item{oracleTempSchema}{DEPRECATED The temp schema if using oracle}

\item{cdmDatabaseSchema}{The schema of the OMOP CDM data}

\item{cdmVersion}{version of the OMOP CDM data}

\item{cohortTable}{the table name that contains the target population cohort}

\item{rowIdField}{string representing the unique identifier in the target population cohort}

\item{aggregated}{whether the covariate should be aggregated}

\item{cohortIds}{cohort id for the target cohort}

\item{covariateSettings}{settings for the covariate cohorts and time periods}

\item{...}{additional arguments from FeatureExtraction}
}
\value{
CovariateData object with covariates, covariateRef, and analysisRef tables
}
\description{
Extracts covariates based on cohorts
}
\details{
The user specifies a cohort and time period and then a covariate is constructed whether they are in the
cohort during the time periods relative to target population cohort index
}
\examples{
\dontshow{if (rlang::is_installed("Eunomia") && rlang::is_installed("curl") && curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long to run }
library(DatabaseConnector)
connectionDetails <- Eunomia::getEunomiaConnectionDetails()
# create some cohort of people born in 1969, index date is their date of birth
con <- connect(connectionDetails)
executeSql(con, "INSERT INTO main.cohort 
                 SELECT 1969 as COHORT_DEFINITION_ID, PERSON_ID as SUBJECT_ID,
                 BIRTH_DATETIME as COHORT_START_DATE, BIRTH_DATETIME as COHORT_END_DATE
                 FROM main.person WHERE YEAR_OF_BIRTH = 1969")
covariateData <- getCohortCovariateData(connection = con,
                                        cdmDatabaseSchema = "main",
                                        aggregated = FALSE,
                                        rowIdField = "SUBJECT_ID",
                                       cohortTable = "cohort",
                                        covariateSettings = createCohortCovariateSettings(
                                                               cohortName="summerOfLove",
                                                               cohortId=1969, 
                                                               settingId=1,
                                                               cohortDatabaseSchema="main",
                                                               cohortTable="cohort"))
covariateData$covariateRef
covariateData$covariates
}
\dontshow{\}) # examplesIf}
}
