% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnc_robustness.R
\name{pnc_robustness}
\alias{pnc_robustness}
\title{Test Robustness of Phylogenetic Niche Conservatism Analysis}
\usage{
pnc_robustness(
  trait_data,
  phylo_tree,
  methods = "lambda",
  pca_axes = c("PC1", "PC2"),
  n_simulations = 100,
  alpha_level = 0.05,
  tolerance = 0.05
)
}
\arguments{
\item{trait_data}{A data frame or matrix containing trait data with species as rows}

\item{phylo_tree}{A phylogenetic tree object of class "phylo"}

\item{methods}{Character string specifying method to use. Options: "lambda" or "K".
Default is "lambda"}

\item{pca_axes}{Character vector specifying which PCA axes to include (e.g., c("PC1", "PC2")).
Default is c("PC1", "PC2")}

\item{n_simulations}{Integer. Number of simulations to run for robustness testing.
Default is 100}

\item{alpha_level}{Numeric. Significance level for statistical testing.
Default is 0.05}

\item{tolerance}{Numeric. Acceptable difference between target and estimated signal
values during trait simulation. Default is 0.05}
}
\value{
A data frame containing the original phylogenetic signal results with
  additional columns:
  \itemize{
    \item robustness: Percentage of simulations that maintain the same statistical
          significance conclusion as the original analysis
    \item signal_sd: Standard deviation of phylogenetic signal values across
          successful simulations
  }
  Returns the enhanced results from the baseline pnc() analysis
}
\description{
This function evaluates the robustness of phylogenetic signal estimates by simulating
trait data with the same phylogenetic signal strength as observed, applying the
original missing data pattern, and testing how consistently the statistical
significance is recovered across multiple simulations.
}
\details{
The robustness testing procedure involves:

1. Performing baseline phylogenetic signal analysis using pnc()

2. For each trait, simulating new trait data with the same phylogenetic signal
   strength as observed in the original data

3. Applying the exact missing data pattern from the original dataset to the
   simulated data

4. Re-testing phylogenetic signal on the simulated data and recording p-values

5. Calculating the percentage of simulations that maintain the same statistical
   significance conclusion (significant vs. non-significant)

The function uses simulate_lambda_trait() or simulate_K_trait() internally to
generate trait data with target phylogenetic signal values.

For PCA axes, the missing data pattern corresponds to complete cases from the
original trait matrix. For individual traits, the original missing pattern is
preserved exactly.
}
\examples{
\donttest{
# Load example data
data(BCI)
data(TRY)

# Extract trait data
sp <- colnames(BCI$com)
subtraits <- extract_traits(sp, TRY, rank = "species",
                          traits = c("LA", "LMA", "LeafN", "PlantHeight"))

# Test robustness of phylogenetic signal analysis
# This function's runtime is long
pnc_robustness(subtraits, BCI$phy_species, methods = "lambda", n_simulations = 5)
}


}
