% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatURL.R
\name{formatURL}
\alias{formatURL}
\title{Format URL for Environmental Data Download}
\usage{
formatURL(
  base,
  dataset,
  fileType,
  vars,
  ranges,
  stride = 1,
  style = c("erddap", "hycom")
)
}
\arguments{
\item{base}{the base URL to download from}

\item{dataset}{the specific datased ID to download}

\item{fileType}{the type of file to download, usually a netcdf}

\item{vars}{a vector of variables to download}

\item{ranges}{a list of three vectors specifying the range of data to download,
must a list with named vectors \code{Longitude}, \code{Latitude}, and \code{UTC}
where each vector is \code{c(min, max)} (Note: even if the time is something like
"dayOfYear" this should still be called 'UTC' for the purpose of this list).
(see \link{dataToRanges}).}

\item{stride}{the stride for all dimensions, a value of 1 gets every data point,
2 gets every other, etc.}

\item{style}{either \code{'erddap'} or \code{'hycom'}}
}
\value{
a properly formatted URL that can be used to download environmental data
}
\description{
This creates a properly formatted URL for downloading environmental
  data either from an ERDDAP or HYCOM server. This URL can be pasted into a browser
  or submitted to something like httr::GET to actually download the data. Also see
  \link{edinfoToURL}
}
\examples{

formatURL(
    base = "https://upwell.pfeg.noaa.gov/erddap/griddap/",
    dataset = "jplMURSST41",
    fileType = "nc",
    vars = "analysed_sst",
    ranges = list(
               Latitude = c(30, 31),
               Longitude = c(-118, -117),
               UTC = as.POSIXct(c('2005-01-01 00:00:00', '2005-01-02 00:00:00'), tz='UTC')
             ),
    stride=1,
    style = 'erddap'
)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
