% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_density.R
\name{OSCV_LI_dens}
\alias{OSCV_LI_dens}
\title{The OSCV function based on the kernel \code{\link{L_I}} in the density estimation (KDE) context.}
\usage{
OSCV_LI_dens(h, dat, alpha, sigma)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{dat}{numerical vecror of data values,}

\item{alpha}{first parameter of the kernel \eqn{L_I},}

\item{sigma}{second parameter of the kernel \eqn{L_I}.}
}
\value{
The vector of values of the OSCV function for the correponsing vector of \eqn{h} values.
}
\description{
Computing the values of the \eqn{L_I}-based OSCV function in the density estimation context. See Savchuk (2017).
}
\details{
Computing the OSCV function for the given vector of bandwidth values \eqn{h} and the data vector \eqn{dat}. The function is based on the one-sided kernel \code{\link{L_I}} that depends on the parameters \eqn{\alpha} and \eqn{\sigma}. The kernel \eqn{L_I} is robust in the special case of \eqn{\alpha=16.8954588} and \eqn{\sigma=1.01}. The other special case is obtained when either of the following holds: \itemize{\item \eqn{\alpha=0} for any \eqn{\sigma>0}; \item \eqn{\sigma=1} for any \eqn{-\infty<\alpha<\infty}.} In the above cases the kernel \eqn{L_I} reduces to the one-sided Gaussian kernel \eqn{L_G}.  The function's minimizer is to be used without additional rescaling to compute the ultimate Gaussian density estimate under the assumption that the underlying density is smooth.
}
\examples{
\dontrun{
# Example 1 (Old Faithful geyser data)
dev.new()
data=faithful[,1]         # Data on n=272 eruption duration of the Old Faithful geyser.
harray=seq(0.025,0.6,len=50)
alp=16.8954588
sig=1.01
plot(harray,OSCV_LI_dens(harray,data,alpha=alp,sigma=sig),lwd=3,'l',xlab="h",
ylab="L_I-based OSCV",main="OSCV_LI(h) for eruption duration",cex.main=1.5,cex.lab=1.7,
cex.axis=1.7)
h_OSCV_LI=round(optimize(OSCV_LI_dens,c(0.001,0.5),tol=0.001,dat=data,alpha=16.8954588,
sigma=1.01)$minimum,digits=4)
legend(0.01,-0.2,legend=c("n=272",paste("h_OSCV_LI=",h_OSCV_LI)),cex=1.8,bty="n")
legend(0.25,-0.33,legend=c("Parameters of L_I:", paste("alpha=",alp),
paste("sigma=",sig)),cex=1.7,bty="n")

# Example 2 (Simulated example)
dat_norm=rnorm(100)   #generating a random sample of size n=100 from the N(0,1) density
harray=seq(0.05,1.5,len=100)
OSCVarray=OSCV_LI_dens(harray,dat=dat_norm,16.8954588,1.01)
dev.new()
plot(harray,OSCVarray,lwd=3,'l',xlab="h",ylab="L_I-based OSCV",
main="OSCV_LI(h) for data generated from N(0,1)",cex.main=1.5,cex.lab=1.7,cex.axis=1.7)
h_OSCV_LI_norm=round(optimize(OSCV_LI_dens,c(0.001,1),tol=0.001,
dat=dat_norm,16.8954588,1.01)$minimum,digits=4)
legend(0,OSCVarray[1],legend=c("n=100",paste("h_OSCV_LI=",h_OSCV_LI_norm),
"Parameters of the robust kernel L_I:","alpha=16.8954588", "sigma=1.01"),cex=1.5,bty="n")
}
}
\references{
Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth density functions, arXiv:1703.05157.
}
\seealso{
\code{\link{OSCV_Gauss_dens}}, \code{\link{OSCV_Epan_dens}}, \code{\link{C_smooth}}, \code{\link{L_I}}, \code{\link{H_I}}.
}
