% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCVgeneral.R
\name{L_I}
\alias{L_I}
\title{The family of one-sided cross-validation kernels \eqn{L_I}.}
\usage{
L_I(u, alpha, sigma)
}
\arguments{
\item{u}{numerical vector of argument values,}

\item{alpha}{first parameter of the cross-validation kernel \eqn{L_I},}

\item{sigma}{second parameter of the cross-validation kernel \eqn{L_I}.}
}
\value{
The value of \eqn{L_I(u;\alpha,\sigma)}.
}
\description{
The one-sided counterpart of the kernel \code{\link{H_I}}. See expressions (15) and (8) of Savchuk and Hart (2017).
}
\details{
The family of the one-sided cross-validation kernels \eqn{L_I} indexed by the parameters \eqn{-\infty<\alpha<\infty} and \eqn{\sigma>0}. This family is used in the OSCV implementations in both regression context (see Savchuk and Hart (2017)) and density estimation context (see Savchuk (2017)). The special members of the family: \itemize{\item The \emph{ robust} kernel used in Savchuk and Hart (2017) and Savchuk (2017) is obtained by setting  \eqn{\alpha=16.8954588} and \eqn{\sigma=1.01}; \item  The one-sided Gaussian kernel \eqn{L_G} is obtained by either setting \eqn{\alpha=0} for any \eqn{\sigma>0} or by setting \eqn{\sigma=1} for any \eqn{-\infty<\alpha<\infty}.} The bandwidth selected by \eqn{L_I} should be multiplied by a reascaling constant before it is used in computing the ultimate Gaussian (regression or density) estimate. In the case of a smooth (regression or density) function the rescaling constant is \code{\link{C_smooth}}.
}
\examples{
\dontrun{
# Plotting the robust one-sided kernel from Savchuk and Hart (2017) with 
# alpha=16.8954588 and sigma=1.01.
u=seq(-1,5,len=1000)
rker=L_I(u,16.8954588,1.01)
Gker=L_I(u,0,1)
dev.new()
plot(u,rker,'l',lwd=3,cex.axis=1.7, cex.lab=1.7)
title(main="One-sided kernels: L_I (robust) and L_G",cex=1.7)
lines(u,Gker,lty="dashed",lwd=3)
legend(0.5,2.5,lty=c("solid","dashed"),lwd=c(3,3),legend=c("L_I","L_G"),cex=1.7)
legend(2,1.5,legend=c("alpha=16.8955","sigma=1.01"),cex=1.5)
}
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D. (2017). Fully robust one-sided cross-validation for regression functions. \emph{Computational Statistics}, doi:10.1007/s00180-017-0713-7.
  \item Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth density functions, arXiv:1703.05157.
}
}
\seealso{
\code{\link{H_I}}, \code{\link{C_smooth}}, \code{\link{OSCV_LI_dens}}.
}
