% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{H_I}
\alias{H_I}
\title{The family of two-sided cross-validation kernels \eqn{H_I}.}
\usage{
H_I(u, alpha, sigma)
}
\arguments{
\item{u}{numerical vector of argument values,}

\item{alpha}{first parameter of the cross-validation kernel \eqn{H_I},}

\item{sigma}{second parameter of the cross-validation kernel \eqn{H_I}.}
}
\value{
The value of \eqn{H_I(u;\alpha,\sigma)}.
}
\description{
The family of two-sided cross-validation kernels \eqn{H_I} defined by equation (15) of Savchuk and Hart (2017).
}
\details{
The family of the two-sided cross-validation kernels \eqn{H_I(u;\alpha,\sigma)=(1+\alpha)\phi(u)-\alpha\phi(u/\sigma)/\sigma}, where \eqn{\phi} denotes the Gaussian kernel, \eqn{-\infty<\alpha<\infty} and \eqn{\sigma>0} are the parameters of the kernel. See expression (15) of Savchuk and Hart (2017). The robust kernel plotted in Figure 1 of Savchuk and Hart (2017) is obtained by setting \eqn{\alpha=16.8954588} and \eqn{\sigma=1.01}. Note that the kernels \eqn{H_I} are also used for the bandwidth selection purposes in the indirect cross-validation (ICV) method (see expression (4) of Savchuk, Hart, and Sheather (2010)). The kernel \eqn{H_I} is a two-sided analog of the one-sided kernel \code{\link{L_I}}. The Gaussian kernel \eqn{\phi} is the special case of \eqn{H_I} obtained by either setting \eqn{\alpha=0} or \eqn{\sigma=1}.
}
\examples{
\dontrun{
# Plotting the robust kernel from Savchuk and Hart (2017) with alpha=16.8954588 and sigma=1.01.
u=seq(-5,5,len=1000)
ker=H_I(u,16.8954588,1.01)
dev.new()
plot(u,ker,'l',lwd=3,cex.axis=1.7, cex.lab=1.7)
title(main="Robust kernel H_I along with the Gaussian kernel (phi)",cex=1.7)
lines(u,dnorm(u),lty="dashed",lwd=3)
legend(-4.85,0.3,lty=c("solid","dashed"),lwd=c(3,3),legend=c("H_I","phi"),cex=1.5)
legend(1,0.4,legend=c("alpha=16.8955","sigma=1.01"),cex=1.5,bty="n")
}
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D. (2017). Fully robust one-sided cross-validation for regression functions. \emph{Computational Statistics}, doi:10.1007/s00180-017-0713-7.
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2010). Indirect cross-validation for density estimation. \emph{Journal of the American Statistical Association}, 105(489), 415-423.
}
}
\seealso{
\code{\link{L_I}}, \code{\link{C_smooth}}, \code{\link{OSCV_reg}}, \code{\link{loclin}}.
}
