% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Big_data.R
\name{GenGLMdata}
\alias{GenGLMdata}
\title{Generate data for Generalised Linear Models}
\usage{
GenGLMdata(Dist,Dist_Par,No_Of_Var,Beta,N,family)
}
\arguments{
\item{Dist}{a character value for the distribution "Normal", "MVNormal", "Uniform or "Exponential"}

\item{Dist_Par}{a list of parameters for the distribution that would generate data for covariate X}

\item{No_Of_Var}{number of variables}

\item{Beta}{a vector for the model parameters, including the intercept}

\item{N}{the big data size}

\item{family}{a character vector for "linear", "logistic" and "poisson" regression from Generalised Linear Models}
}
\value{
The output of \code{GenGLMdata} gives a list of

\code{Complete_Data} a matrix for Y and X
}
\description{
Function to simulate big data under linear, logistic and Poisson regression for sampling.
Covariate data X is through Normal, Multivariate Normal or Uniform distribution for linear regression.
Covariate data X is through Exponential, Normal, Multivariate Normal or Uniform distribution for logistic regression.
Covariate data X is through Normal or Uniform distribution for Poisson regression.
}
\details{
Big data for the Generalised Linear Models are generated by the "linear", "logistic" and "poisson"
regression types.

We have limited the covariate data generation for
linear regression through normal, multivariate normal and uniform distribution,
logistic regression through exponential, normal, multivariate normal and uniform distribution
Poisson regression through normal and uniform distribution.
}
\examples{
No_Of_Var<-2; Beta<-c(-1,2,1); N<-5000;

Dist<-"MVNormal";
Dist_Par<-list(Mean=rep(0,No_Of_Var),Variance=diag(rep(2,No_Of_Var)),Error_Variance=0.5)
Family<-"linear"
Results<-GenGLMdata(Dist,Dist_Par,No_Of_Var,Beta,N,Family)

Dist<-"Normal"; Dist_Par<-list(Mean=0,Variance=1);
Family<-"logistic"
Results<-GenGLMdata(Dist,Dist_Par,No_Of_Var,Beta,N,Family)

Dist<-"Uniform"; Family<-"poisson"
Results<-GenGLMdata(Dist,NULL,No_Of_Var,Beta,N,Family)

}
\references{
\insertRef{lee1996hierarchical}{NeEDS4BigData}
}
