% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.fixed.effects.p.R
\name{get.fixed.effects.p}
\alias{get.fixed.effects.p}
\title{Export parametrization of fixed effects}
\usage{
get.fixed.effects.p(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: FALSE)}
}
\value{
Estimated breeding value of in gen/database/cohorts selected individuals
}
\description{
Function to export parametrization of the fixed effects
}
\examples{
data(ex_pop)
population <- add.fixed.effects(ex_pop, fixed.effects = cbind(1,5))
population <- breeding.diploid(population, heritability = 0.3,
fixed.effects.p = rbind(c(1,0), c(0,1)), phenotyping.gen=2)
get.fixed.effects.p(population, gen=2)
}
