% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hc_active_ingredients.R
\name{get_hc_active_ingredients}
\alias{get_hc_active_ingredients}
\title{Get Active Ingredients from Health Canada Drug Product Database}
\source{
Health Canada Drug Product Database (DPD) API:
\url{https://health-products.canada.ca/api/documentation/dpd-documentation-en.html}
}
\usage{
get_hc_active_ingredients()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{dosage_unit}: Unit of dosage form (e.g., "ML", "%", "W/W")
  \item \code{dosage_value}: Numeric dosage quantity (e.g., "100")
  \item \code{drug_code}: Unique code identifying the drug product
  \item \code{ingredient_name}: Name of the active ingredient
  \item \code{strength}: Strength or concentration value (e.g., "50", "0.05")
  \item \code{strength_unit}: Unit of the strength (e.g., "MG", "G", "%", "NIL")
}
}
\description{
Retrieves detailed information on all active ingredients
listed in the Health Canada Drug Product Database (DPD)
through the RESTful API endpoint \code{/drug/activeingredient}.

Each record corresponds to a specific active ingredient
within a registered drug product, including concentration,
unit, and dosage details (if available).
}
\details{
The function sends a GET request to the Health Canada DPD API.
It uses memoisation via the \pkg{memoise} package to cache results
and includes a rate limit delay between API requests.

Missing values are retained as empty strings (\code{""}),
preserving the original schema of the API.
}
\note{
Requires an active internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from Health Canada
  get_hc_active_ingredients()
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
