% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost2ecad.R
\name{cost2ecad}
\alias{cost2ecad}
\title{Converter from the COST Home format into the ECA&D format (blended version)}
\usage{
cost2ecad(homefolder = "./")
}
\arguments{
\item{homefolder}{path to the home directory which should contain the subdirectory 'raw_COST' with
files in the COST Home format. Files of all variables must be stored in 'raw_COST'}
}
\value{
station and data files in the ECA&D format stored in the subdirectory 'raw'
}
\description{
This function will convert station and data files in COST Home format into
corresponding station and data files in the ECA&D format (blended version)
}
\examples{
#Set a temporal working directory:
wd <- tempdir(); wd0 <- setwd(wd)
#Create subdirectory where raw data files in the COST format have to be located
dir.create(file.path(wd, "raw_COST"))
#TG: Extract the COST data and station files from the example data folder
path2tglist<-system.file("extdata", "000001stations.txt", package = "INQC")
tglist<-readr::read_lines_raw(path2tglist)
readr::write_lines(tglist,file=paste0(wd,"/raw_COST/000001stations.txt"))
path2tgdata1<-system.file("extdata", "ratmd00000001d.txt", package = "INQC")
tgdata1<-readr::read_lines_raw(path2tgdata1)
readr::write_lines(tgdata1, file=paste0(wd,"/raw_COST/ratmd00000001d.txt"))
path2tgdata2<-system.file("extdata", "ratmd00000005d.txt", package = "INQC")
tgdata2<-readr::read_lines_raw(path2tgdata2)
readr::write_lines(tgdata2, file=paste0(wd,"/raw_COST/ratmd00000005d.txt"))
#PP: Extract the COST data and station files from the example data folder
path2pplist<-system.file("extdata", "000002stations.txt", package = "INQC")
pplist<-readr::read_lines_raw(path2pplist)
readr::write_lines(pplist,file=paste0(wd,"/raw_COST/000002stations.txt"))
path2ppdata1<-system.file("extdata", "rappd00000001d.txt", package = "INQC")
ppdata1<-readr::read_lines_raw(path2ppdata1)
readr::write_lines(ppdata1, file=paste0(wd,"/raw_COST/rappd00000001d.txt"))
path2ppdata2<-system.file("extdata", "rappd00000012d.txt", package = "INQC")
ppdata2<-readr::read_lines_raw(path2ppdata2)
readr::write_lines(ppdata2, file=paste0(wd,"/raw_COST/rappd00000012d.txt"))
#Call the converter
cost2ecad(homefolder = "./")
#The results can be found in the directory:
print(wd)
#Return to user's working directory:
setwd(wd0)
}
