% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{resid_ID}
\alias{resid_ID}
\title{Calculate the residuals related to the estimated signal}
\usage{
resid_ID(x, cpt, type_chg = c("mean", "slope"), type_res = c("raw",
  "standardised"))
}
\arguments{
\item{x}{A numeric vector containing the data.}

\item{cpt}{A positive integer vector with the locations of the change-points.
If missing, the \code{\link{ID}} function is called internally to detect any change-points
that might be present in \code{x}.}

\item{type_chg}{A character string, which defines the type of the detected change-points.
If \code{type_chg = ``mean''}, then the change-points represent the locations of changes
in the mean of a piecewise-constant signal. If \code{type_chg = ``slope''}, then the
change-points represent the locations of changes in the slope of a piecewise-linear
and continuous signal.}

\item{type_res}{A choice of \code{``raw''} and \code{``standardised''} residuals.}
}
\value{
If \code{type_res = ``raw''}, the function returns the difference between the data
  and the estimated signal. If \code{type_res = ``standardised''}, then the function
  returns the difference between the data and the estimated signal, divided by
  the estimated standard deviation.
}
\description{
This function returns the difference between \code{x} and the estimated signal
with change-points at \code{cpt}. The input in the argument \code{type_chg} will
indicate the type of changes in the signal.
}
\examples{
single.cpt.pcm <- c(rep(4,1000),rep(0,1000))
single.cpt.pcm.noise <- single.cpt.pcm + rnorm(2000)
cpt_detect <- ID(single.cpt.pcm.noise, contrast = "mean")

residuals_cpt_raw <- resid_ID(single.cpt.pcm.noise, cpt = cpt_detect$cpt, type_chg = "mean",
type_res = "raw")

residuals_cpt_stand. <- resid_ID(single.cpt.pcm.noise, cpt = cpt_detect$cpt, type_chg = "mean",
type_res = "standardised")

plot(residuals_cpt_raw)
plot(residuals_cpt_stand.)
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
