% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{getFeat}
\alias{getFeat}
\title{Feature selection based on differentially expressed genes}
\usage{
getFeat(x, y, tar, fpv = 0.05, ...)
}
\arguments{
\item{x}{expression data frame with genes as rows and cells as columns. Gene IDs should be given as row names and cell IDs should be given as column names. This can be a reduced expression table only including the features (genes) to be used in the analysis.}

\item{y}{clustering partition. A vector with an integer cluster number for each cell. The order of the cells has to be the same as for the columns of x.}

\item{tar}{vector of integers representing target cluster numbers. Each element of \code{tar} corresponds to a cluster of cells committed towards a particular mature state. One cluster per different cell lineage has to be given and is used as a starting point for learning the differentiation trajectory.}

\item{fpv}{p-value cutoff for calling differentially expressed genes. This is a cutoff for the Benjamini-Hochberg corrected false discovery rate. Default value is 0.05.}

\item{...}{additional arguments to be passed to the low level function \code{diffexpnb}.}
}
\value{
A filtered expression table with features extracted based on differentially expressed genes.
}
\description{
This function performs a feature selection based on the inference of differentially expressed genes between each target cluster and all remaining cells.
}
\details{
The function determines differentially expressed between the cells in each of the target clusters in comparison to the remaining cells by using \code{diffexpnb} function.
}
\examples{
x <- intestine$x
y <- intestine$y
tar <- c(6,9,13)
xf <- getFeat(x,y,tar,fpv=.05)
}
