% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacheManager.R
\name{cachePath}
\alias{cachePath}
\title{Function used to build a file path based on a cache folder}
\usage{
cachePath(...)
}
\arguments{
\item{...}{character vectors. Elements of the subpath of cache path}
}
\value{
A character vector of normalized file path with a source attribute
holding a hint to cache path source ("option", "data", "temp")
}
\description{
Parameters are similar to that of file.path function
}
\section{Localisation}{

Cache path discovery protocol
\enumerate{
\item BIOMASS.cache option set to an \strong{existing} folder
\item \strong{existing} user data folder \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}
\itemize{
\item On Linux : \verb{~/.local/share/R/BIOMASS}
\item On Mac OS X : \verb{~/Library/Application Support/R/BIOMASS}
\item On Windows 7 up to 10 : \verb{C:\\\\Users\\\\<username>\\\\AppData\\\\Local\\\\R\\\\BIOMASS}
\item On Windows XP : \verb{C:\\\\Documents and Settings\\\\<username>\\\\Data\\\\R\\\\BIOMASS}
}
\item fallback to R session tempdir
}
}

