% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor_prediction_gam.R
\name{anchor_prediction_gam}
\alias{anchor_prediction_gam}
\title{anchor_prediction}
\usage{
anchor_prediction_gam(
  anchor_model,
  x,
  anchor,
  gamma,
  target_variable,
  bin_factor
)
}
\arguments{
\item{anchor_model}{is the Anchor Regression model object}

\item{x}{is a dataframe containing the matrix x containing the independent variables}

\item{anchor}{is a dataframe containing the matrix anchor containing the anchor variable}

\item{gamma}{is the regularization parameter for the Anchor Regression}

\item{target_variable}{is the target variable name contained in the x dataframe}

\item{bin_factor}{binary variable that can be transformed to a factor to partial out effects}
}
\value{
A list of predictions.
}
\description{
Perform a prediction for an Anchor Regression model as described in Rothenhäusler et al.2020
}
\examples{
x <- as.data.frame(matrix(data = rnorm(10000),nrow = 1000,ncol = 10))
x$bin <- sample(nrow(x),x = c(1,0),prob = c(0.5,0.5),replace = TRUE)
anchor <- as.data.frame(matrix(data = rnorm(2000),nrow = 1000,ncol = 2))
colnames(anchor) <- c('X1','X2')
gamma <- 2
target_variable <- 'V2'

anchor_model <- anchor_regression_gam(x, anchor, gamma, target_variable,"bin")
anchor_prediction_gam(anchor_model$model, x, anchor, gamma, target_variable,"bin")
}
