% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_meta.R
\name{tt_meta}
\alias{tt_meta}
\title{Create and open meta.yaml}
\usage{
tt_meta(
  path = "tt_submission",
  title,
  article_title,
  article_url,
  source_title,
  source_url,
  image_filename,
  image_alt,
  attribution,
  github = gh::gh_whoami()$login,
  bluesky = NULL,
  linkedin = NULL,
  mastodon = NULL,
  open = rlang::is_interactive(),
  ignore = FALSE
)
}
\arguments{
\item{path}{The relative path to the directory to hold your submission files
(\code{tt_submission} by default). If this directory does not exist, it will be
created.}

\item{title}{A short title for your submission. It should fit into the
sentence "This week we're exploring \code{title}!" For example, for "This week
we're exploring The 50 US States!", the \code{title} would be \code{"The 50 US States"}.}

\item{article_title}{The title of an article or other website that has
something to do with the data. This should usually be an article that uses
or describes the dataset, but any related website is acceptable.}

\item{article_url}{The URL of the article whose title is \code{article_title}.}

\item{source_title}{The title of the source of the dataset. This is usually a
website, but might be an R package or a journal article, for example.}

\item{source_url}{A URL associated with the source. Ideally this should be a
URL where users can download the data, but, if that isn't possible, provide
a URL that is somehow related to the source of the data.}

\item{image_filename}{A character vector with at least one file name for an
image to accompany the post. This might be a plot of the data, or some othe
image somehow connected to the data.}

\item{image_alt}{Text that can take the place of the image for a visually
impaired user or anybody else who cannot see the image. Don't just say "A
plot of the data", but rather describe what information you can glean from
the plot, such as "A map of the continental United States, with each state
colored in shades of blue by population as of 1975. California and New York
are the lightest, indicating the highest population. Maine, New Hampshire,
Vermont, and the Plains States are all quite dark, indicating low
population."}

\item{attribution}{Your name as you would like it to appear when we credit
you in the post for this dataset. You can include a title and/or
affiliation if you like, such as "Jon Harmon, Executive Director, Data
Science Learning Community".}

\item{github}{Your GitHub username, or a link to your profile on GitHub.}

\item{bluesky}{Your Bluesky username, or a link to your profile on Bluesky.
Leave as \code{NULL} if you do not wish to be credited on Bluesky.}

\item{linkedin}{Your LinkedIn username, or a link to your profile on LinkedIn
Leave as \code{NULL} if you do not wish to be credited on LinkedIn.}

\item{mastodon}{Your mastodon server and username, or a link to your profile
on a mastodon server. Leave as \code{NULL} if you do not wish to be credited on
Mastodon.}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}
}
\value{
A logical vector indicating whether the file was created or
modified, invisibly.
}
\description{
We need a set of metadata information about each TidyTuesday dataset. Use
this function to set up the \code{meta.yaml} file for your submission (and create
the submission directory if it does not already exist). If you do not provide
values for the parameters, you will be prompted to enter them in an
interactive session.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

  tt_meta()
\dontshow{\}) # examplesIf}
}
