% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{qualtrics_api_request}
\alias{qualtrics_api_request}
\title{Send httr requests to Qualtrics API}
\usage{
qualtrics_api_request(
  verb = c("GET", "POST"),
  url = url,
  query = NULL,
  body = NULL,
  as = c("parsed", "raw"),
  ...
)
}
\arguments{
\item{verb}{Type of request to be sent (@seealso \code{\link[httr:VERB]{httr::VERB()}})}

\item{url}{Qualtrics endpoint URL created by \code{\link[=generate_url]{generate_url()}} functions}

\item{query}{Optional query parameters used by some endpoints}

\item{body}{Options created by \code{\link[=create_raw_payload]{create_raw_payload()}} function}

\item{as}{type of content to return, passed to \code{as} in httr::content().
current options "parsed" (since we get JSON mostly), "raw" (response .zips)}

\item{...}{arguments passed to httr::content when parsing}
}
\description{
Send httr requests to Qualtrics API
}
\details{
If the request to the Qualtrics API made by this function fails, the request
will be retried. If you see these failures on a 500 error (such as a 504
error) be patient while the request is retried; it will typically succeed
on retrying. If you see other types of errors, retrying is unlikely to help.
}
\keyword{internal}
