% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_colmap.R
\name{extract_colmap}
\alias{extract_colmap}
\title{Extract column map from survey data download}
\usage{
extract_colmap(respdata)
}
\arguments{
\item{respdata}{Response data including a column map dataframe as an attribute}
}
\description{
Helper function to extract the column map attached to a response data
download obtained from \code{\link[=fetch_survey]{fetch_survey()}} (using the
default \code{add_column_map = TRUE})
}
\details{
If the request to the Qualtrics API made by this function fails, the request
will be retried. If you see these failures on a 500 error (such as a 504
error) be patient while the request is retried; it will typically succeed
on retrying. If you see other types of errors, retrying is unlikely to help.
}
\examples{
\dontrun{
# Retrieve a list of surveys
surveys <- all_surveys()

# Retrieve a single survey
mysurvey <- fetch_survey(surveyID = surveys$id[6])

# Extract column mapping for survey
extract_colmap(mysurvey)
}

}
