% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelativeWaterContent.R
\name{RelativeWaterContent}
\alias{RelativeWaterContent}
\title{Relative Water Content (RWC)}
\usage{
RelativeWaterContent(
  data,
  fresh.mass = "fresh.mass",
  dry.mass = "dry.mass",
  fresh.mass.saturated = "fresh.mass.saturated"
)
}
\arguments{
\item{data}{data frame with columns of equal length containing at least columns with the fresh mass (g),
the dry mass (g) and the saturated fresh mass (g)}

\item{fresh.mass}{optional name of the column in data containing
the numeric fresh mass values (g); default: "fresh.mass"}

\item{dry.mass}{optional name of the column in data containing
the numeric dry mass values (g); default: "dry.mass"}

\item{fresh.mass.saturated}{optional name of the column in data containing
the numeric saturated fresh mass values (g); default: "fresh.mass.saturated"}
}
\value{
the original data frame extended by a numeric column with the relative water content (RWC) (\%).
}
\description{
Calculates relative water content (RWC, \%)
}
\details{
Relative water content (\%) is calculated as:
\deqn{RWC = 100 * ((FM - DM) (FMs - DM)^-1)}
whereas FM = fresh mass, DM = dry mass and FMs = fresh mass at water saturation.
}
\examples{
# get example data
df <- pressure_volume_data

# extend df by RWC
df_with_RWC <- RelativeWaterContent(df)

}
