% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treestat.R
\name{treestat}
\alias{treestat}
\title{Significance test of user defined phylogenetic metric}
\usage{
treestat(phy, stlist = NULL, state = NULL, func, par = NULL,
  traitevol = NULL, a = NULL, alternative = "two.sided", simplify = T)
}
\arguments{
\item{phy}{an object of class 'phylo'.}

\item{stlist}{a vector of tip labels with trait state '1'.}

\item{state}{a vector of '0' and '1' for trait state of each tip, in the same order as the tip labels.}

\item{func}{name of the function that calculates the metric. The first two inputs of the function need to be the state vector and the phylo class.}

\item{par}{values of additional parameters used in the above function.}

\item{traitevol}{the null model of trait evolution used in the significance test of the metric. traitevol = "TBM" is the threshold brownian motion with the same trait prevalence as observed. traitevol = "random" is the random reshuffle of tip states. If users only want to calculate the value of the metric or if the null model is defined in the 'func' already, traitevol = NULL.}

\item{a}{number of traits simulated under the null model of trait evolution.}

\item{alternative}{the alternative hypothesis for the significant test of the metric. alternative = "greater", if users want to test if the observed trait has significantly larger metric value than expected by the null model of trait evolution. alternative = "less", if users want to test if the observed trait has significantly smaller metric value. alternative = "two.sided" (default), if users have no prior knowledge on how the observed trait may differ from the null model.}

\item{simplify}{if TRUE, the output is simplified. The full output includes the p.value, metric value of the observed trait, metric values of the simulated traits, a matrix, each row of which is the state vector of a simulated trait. The simplified output includes the p.value.}
}
\description{
This function conducts the significance test of a phylogenetic metric defined by users.
}
\details{
In the example, we conduct significane test on a metric defined by 'tars' function for a simulated phylogeny. The null hypothesis is that the trait is randomly distributed across tips. We don't know if the trait will have larger or smaller metric value than expected, so we apply a "two.sided" test. 1000 traits are simulated to generate the null distribution of the metric.
The state vector is included in the phylo class as the output of treesim, so we don't need to input state here.
}
\examples{
phy <- treesim(pars=c(0.1,0.1,0.05,0.05,0.1,0.1),N0=50,N1=50,sampling.f=c(1,1),max.t=Inf)
treestat(phy, func=tars, traitevol="random", a=1000, alternative="two.sided", simplify=TRUE)
}

