% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtreeShow.R
\name{subtreeShow}
\alias{subtreeShow}
\title{Highlight a subtree}
\usage{
subtreeShow(
  tree,
  nodeList,
  showNodeLabels = "nodeList",
  mainCol = "black",
  subtreeCol = "red",
  nodeLabelCol = "lightblue",
  ...
)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{nodeList}{a list of one or more internal nodes in the tree.}

\item{showNodeLabels}{option of whether to show node labels. Default is "nodeList", which only labels the nodes in \code{nodeList}.
Choosing \code{showNodeLabels="all"} will display all node labels; any other arguments will remove all node labels.}

\item{mainCol}{colour for the edges which are not highlighted (default is black).}

\item{subtreeCol}{colour for the edges which are highlighted (default is red).}

\item{nodeLabelCol}{background colour for any node labels shown (default is light blue)}

\item{...}{further arguments to be passed to plot.phylo}
}
\value{
A plot of the tree, with clade(s) descending from the given node(s) highlighted.
}
\description{
Plot a tree, highlighting the clade(s) descending from the given node(s)
}
\examples{
## Highlight the clade(s) descending from nodes 23 and 35 in a random tree on 20 tips:
tree <- rtree(20)
subtreeShow(tree, nodeList=c(23,35))
# change aesthetics:
subtreeShow(tree,nodeList=c(23,35), mainCol="navy", subtreeCol="cyan", 
   nodeLabelCol="cyan", edge.width=2)
   

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
