% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf_get.R
\name{taf_get}
\alias{taf_get}
\alias{taf_get_cached}
\title{Get a url}
\usage{
taf_get(url, retry = TRUE, quiet = getOption("icesTAF.messages") \%||\%
  FALSE, verbose = FALSE, content = TRUE,
  use_token = getOption("icesTAF.use_token") \%||\% FALSE)

taf_get_cached(url, retry = TRUE, quiet = getOption("icesTAF.messages")
  \%||\% FALSE, verbose = FALSE, content = TRUE,
  use_token = getOption("icesTAF.use_token") \%||\% FALSE)
}
\arguments{
\item{url}{the url to get.}

\item{retry}{should the get request be retried if first attempt
fails? default TRUE.}

\item{quiet}{should all messages be suppressed, default FALSE.}

\item{verbose}{should verbose output form the http request be
returned? default FALSE.}

\item{content}{should content be returned, or the full http response?
default TRUE, i.e. content is returned by default.}

\item{use_token}{should an authentication token be sent with the
request? default is the value of the option icesSAG.use_token.}
}
\value{
content or an http response.
}
\description{
Get a url, optionally using an ICES authentication token
}
\section{Functions}{
\itemize{
\item \code{taf_get_cached()}: cached version of taf_get

}}
\examples{
\dontrun{
taf_get(taf_api("FLStocks"))
}
}
\seealso{
\code{\link{taf_api}} builds a SAG web service url.

\code{\link{icesTAF-package}} gives an overview of the package.
}
