% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haldensify.R
\name{cv_haldensify}
\alias{cv_haldensify}
\title{HAL Conditional Density Estimation in a Cross-validation Fold}
\usage{
cv_haldensify(
  fold,
  long_data,
  wts = rep(1, nrow(long_data)),
  lambda_seq = exp(seq(-1, -13, length = 1000L)),
  smoothness_orders = 0L,
  ...
)
}
\arguments{
\item{fold}{Object specifying cross-validation folds as generated by a call
to \code{\link[origami]{make_folds}}.}

\item{long_data}{A \code{data.table} or \code{data.frame} object containing
the data in long format, as given in \insertRef{diaz2011super}{haldensify},
as produced by \code{\link{format_long_hazards}}.}

\item{wts}{A \code{numeric} vector of observation-level weights, matching in
its length the number of records present in the long format data. Default
is to weight all observations equally.}

\item{lambda_seq}{A \code{numeric} sequence of values of the regularization
parameter of Lasso regression; passed to \code{\link[hal9001]{fit_hal}}.}

\item{smoothness_orders}{A \code{integer} indicating the smoothness of the
HAL basis functions; passed to \code{\link[hal9001]{fit_hal}}. The default
is set to zero, for indicator basis functions.}

\item{...}{Additional (optional) arguments of \code{\link[hal9001]{fit_hal}}
that may be used to control fitting of the HAL regression model. Possible
choices include \code{use_min}, \code{reduce_basis}, \code{return_lasso},
and \code{return_x_basis}, but this list is not exhaustive. Consult the
documentation of \code{\link[hal9001]{fit_hal}} for complete details.}
}
\value{
A \code{list}, containing density predictions, observations IDs,
 observation-level weights, and cross-validation indices for conditional
 density estimation on a single fold of the overall data.
}
\description{
HAL Conditional Density Estimation in a Cross-validation Fold
}
\details{
Estimates the conditional density of A|W for a subset of the full
 set of observations based on the inputted structure of the cross-validation
 folds. This is a helper function intended to be used to select the optimal
 value of the penalization parameter for the highly adaptive lasso estimates
 of the conditional hazard (via \code{\link[origami]{cross_validate}}). The
}
