% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gravityGE.R
\name{gravityGE}
\alias{gravityGE}
\title{Solves one sector Armington-CES gravity model with general equilibrium}
\usage{
gravityGE(
  trade_data,
  theta = 4,
  beta_hat_name = NULL,
  a_hat_name = NULL,
  multiplicative = FALSE
)
}
\arguments{
\item{trade_data}{A data frame that contains 'orig', 'dest', and 'flow' named columns, with additional variables as described below.}

\item{theta}{Trade elasticity parameter (default = 4).}

\item{beta_hat_name}{A character name in trade_data for the beta_hat variable. If NULL, a matrix of ones is used. Domestic trade ('orig' == 'dest') must have a value of 0.}

\item{a_hat_name}{A character name in trade_data for the a_hat variable. If NULL, a matrix of ones is used. All values across 'orig' in a_hat must be the same.}

\item{multiplicative}{Logical. If TRUE, the model is multiplicative. If FALSE, the model is additive. Default = FALSE. Additive is recommended when trade data is unbalanced.}
}
\value{
A list containing two data frames. A dyadic ('orig' and 'dest') data frame with the new trade flows, and a unidirectional ('orig') data frame with the welfare effects.
}
\description{
Solves one sector Armington-CES gravity model with general equilibrium
}
\examples{

flows <- expand.grid(LETTERS, LETTERS)
flows$flow <- 1
names(flows)[1:2] <- c("orig", "dest")

# There should be no change in welfare (all ones)
out <- gravityGE::gravityGE(
  trade_data = flows,
  theta = 4,
  beta_hat_name = NULL,
  a_hat_name = NULL,
  multiplicative = FALSE
)


}
