% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcConnectionsHelpers.R
\name{getRelativeCoordinates}
\alias{getRelativeCoordinates}
\title{Get coordinate positions of relatives for each individual}
\usage{
getRelativeCoordinates(
  ped,
  connections,
  relativeIDvar,
  x_name,
  y_name,
  personID = "personID",
  multiple = "all",
  only_unique = TRUE
)
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, and dadID columns}

\item{connections}{A `data.frame` containing the individuals and their associated relative IDs.}

\item{relativeIDvar}{Character. Name of the column in `connections` for the relative ID variable.}

\item{x_name}{Character. Name of the new column to store the x-coordinate of the relative.}

\item{y_name}{Character. Name of the new column to store the y-coordinate of the relative.}

\item{personID}{Character string specifying the column name for individual IDs. Defaults to "personID".}

\item{multiple}{Character. Specifies how to handle multiple matches. Options are "all" or "any".}

\item{only_unique}{Logical. If TRUE, return only unique rows. Defaults to TRUE.}
}
\value{
A `data.frame` with columns:
  \itemize{
    \item `personID`, `relativeIDvar`
    \item `x_name`, `y_name`: Coordinates of the specified relative
    \item Optionally, `newID` if present in `ped`
  }
}
\description{
Helper function used to retrieve the x and y coordinates of a specified relative
(e.g., mom, dad, spouse) and join them into the main connection table. This supports
relative-specific positioning in downstream layout functions like `calculateConnections()`.
}
\keyword{internal}
