% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCoordinates.R
\name{alignPedigreeWithRelations}
\alias{alignPedigreeWithRelations}
\title{Align pedigree with additional relations}
\usage{
alignPedigreeWithRelations(
  ped,
  personID,
  dadID,
  momID,
  code_male,
  sexVar,
  config
)
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, and dadID columns}

\item{personID}{Character string specifying the column name for individual IDs. Defaults to "personID".}

\item{dadID}{Character string specifying the column name for father IDs. Defaults to "dadID".}

\item{momID}{Character string specifying the column name for mother IDs. Defaults to "momID".}

\item{code_male}{Value used to indicate male sex. Defaults to NULL.}

\item{sexVar}{Character. Name of the column in `ped` for the sex variable.}

\item{config}{List of configuration options:
\describe{
  \item{code_male}{Default is 1. Used by BGmisc::recodeSex().}
  \item{ped_packed}{Logical, default TRUE. Passed to `kinship2::align.pedigree`.}
  \item{ped_align}{Logical, default TRUE. Align generations.}
  \item{ped_width}{Numeric, default 15. Controls spacing.}
}}
}
\value{
A data frame with the aligned positions of individuals in the pedigree.
}
\description{
This function aligns a pedigree object using relations if provided, or
defaults to the default alignment settings.
}
\keyword{internal}
