% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_boot.R
\name{auc_ci}
\alias{auc_ci}
\title{Bootstrap confidence intervals for AUC}
\usage{
auc_ci(cpf, caf, group = NULL, nboot = 1000, alpha = 0.05, ...)
}
\arguments{
\item{cpf}{A vector of cp frequencies.}

\item{caf}{A vector of ca frequencies.}

\item{group}{A vector indicating group membership. Will calculate AUC by group.}

\item{nboot}{Number of bootstrap iterations. Defaults to 1,000.}

\item{alpha}{Alpha level for the CIs. Defaults to 0.05.}

\item{...}{Additional arguments in \link[fullROC:auc_boot]{auc_boot}. Will allow users to adjust ca id rates in each simulation.}
}
\value{
A data frame of CIs for each group and group differences.
}
\description{
A function to simulate bootstrap samples and calculate CIs for AUC and differences.
}
\examples{
cpf1 <- c(100, 90, 80, 20, 10, 5)
caf1 <- c(6, 7, 15, 50, 75, 120)
auc_ci(cpf1, caf1, nboot = 50)

cpf2 <- c(90, 40, 20)
caf2 <- c(10, 70, 80)
auc_ci(cpf2, caf2, nboot = 100)

## compare two groups
cpf <- c(cpf1, cpf2)
caf <- c(caf1, caf2)
group <- rep(letters[1:2], times = c(length(cpf1), length(cpf2) ) )
auc_ci(cpf, caf, group = group)

}
\references{
Yueran Yang & Andrew Smith. (2020). "fullROC: An R package for generating and analyzing eyewitness-lineup ROC curves"
\doi{10.13140/RG.2.2.20415.94885/1}

Andrew Smith, Yueran Yang, & Gary Wells. (2020). "Distinguishing between investigator discriminability and eyewitness discriminability: A method for creating full receiver operating characteristic curves of lineup identification performance". \emph{Perspectives on Psychological Science, 15}(3), 589-607.
\doi{10.1177/1745691620902426}
}
