% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R, R/aliases.R
\name{cardProfile}
\alias{cardProfile}
\alias{cardProfileItem}
\alias{boxProfile}
\alias{boxProfileItem}
\title{AdminLTE3 card profile}
\usage{
cardProfile(..., image = NULL, title, subtitle = NULL, bordered = FALSE)

cardProfileItem(title, description)

boxProfile(..., image = NULL, title, subtitle = NULL, bordered = FALSE)

boxProfileItem(title, description)
}
\arguments{
\item{...}{Any element such as \link{boxProfileItem}.}

\item{image}{Profile image, if any.}

\item{title}{Item title.}

\item{subtitle}{Subtitle.}

\item{bordered}{Whether the container should have a border or not. FALSE by default.}

\item{description}{Item info.}
}
\description{
\link{boxProfile} goes inside a \link{box}. Displays user informations in an elegant
container.

Create card profile item
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(
        sidebarMenu(
          sidebarHeader("Main content"),
          menuItem(
            "Profile Card",
            tabName = "profile_card",
            icon = icon("desktop")
          )
        )
      ),
      controlbar = dashboardControlbar(),
      footer = dashboardFooter(),
      title = "boxProfile",
      body = dashboardBody(
        tabItems(
          tabItem(
            tabName = "profile_card",
            bs4Card(
              status = "primary",
              solidHeader = TRUE,
              boxProfile(
                image = "https://adminlte.io/themes/AdminLTE/dist/img/user4-128x128.jpg",
                title = "Nina Mcintire",
                subtitle = "Software Engineer",
                bordered = TRUE,
                boxProfileItem(
                  title = "Followers",
                  description = 1322
                ),
                boxProfileItem(
                  title = "Following",
                  description = 543
                ),
                boxProfileItem(
                  title = "Friends",
                  description = 13287
                )
              )
            )
          )
        )
      )
    ),
    server = function(input, output) {}
  )
}
}
\seealso{
Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4CardSidebar}()},
\code{\link{bs4Carousel}()},
\code{\link{bs4SocialCard}()},
\code{\link{bs4Timeline}()},
\code{\link{cardDropdown}()},
\code{\link{descriptionBlock}()},
\code{\link{userPost}()}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\concept{boxWidgets}
