% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_flatten_sds}
\alias{process_flatten_sds}
\title{Process MODIS layers}
\usage{
process_flatten_sds(path = NULL, subdataset = NULL, fun_agg = "mean", ...)
}
\arguments{
\item{path}{character(1). Full path to MODIS HDF4/HDF5 file.
Direct sub-dataset access is supported, for example,
HDF4_EOS:EOS_GRID:\{filename\}:\{base_grid_information\}:\{sub-dataset\}}

\item{subdataset}{character(1). Exact or regular expression filter of
sub-dataset. See \link{process_modis_sds} for details.}

\item{fun_agg}{character(1). Function name to aggregate layers.
Should be acceptable to \link[terra:tapp]{terra::tapp}.}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object
}
\description{
Aggregate layers in a sub-dataset in sinusoidal MODIS products.

Some MODIS products consist of multi-layer subdatasets.
This function aggregates multiple layers into single layer \code{SpatRaster.}
\code{fun_agg} is applied at overlapping cells.
}
\note{
HDF values are read as original without scaling.
Users should consult MODIS product documentation to apply proper
scaling factor for post-hoc adjustment. If users have no preliminary
information about MODIS sub-datasets, consider running
\verb{terra::describe(__filename__, sds = TRUE)} to navigate the full
list of sub-datasets in the input file then consult the documentation
of MODIS product.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
mod09ga_flatten <- process_flatten_sds(
  path =
    list.files("./data", pattern = "MOD09GA.", full.names = TRUE)[1],
  subdataset = process_modis_sds("MOD09GA"),
  fun_agg = "mean"
)
}
}
\seealso{
\link[terra:tapp]{terra::tapp}, \link[terra:rast]{terra::rast}, \link[terra:describe]{terra::describe}
}
\author{
Insang Song
}
\keyword{internal}
