% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fleish_Hessian.R
\name{fleish_Hessian}
\alias{fleish_Hessian}
\title{Fleishman's Third-Order Transformation Hessian Calculation for Lower Boundary of Standardized Kurtosis in Asymmetric Distributions}
\usage{
fleish_Hessian(c)
}
\arguments{
\item{c}{a vector of constants c1, c3, lambda}
}
\value{
A list with components:

\code{Hessian} the Hessian matrix H

\code{H_det} the determinant of H
}
\description{
This function gives the second-order conditions necessary to verify that a kurtosis is a global minimum.  A kurtosis solution from
    \code{\link[SimMultiCorrData]{fleish_skurt_check}} is a global minimum if and only if the determinant of the bordered Hessian, \eqn{H}, is
    less than zero (see Headrick & Sawilowsky, 2002, \doi{10.3102/10769986025004417}), where
    \deqn{|\bar{H}| = matrix(c(0, dg(c1, c3)/dc1, dg(c1, c3)/dc3,}
    \deqn{dg(c1, c3)/dc1, d^2 F(c1, c3, \lambda)/dc1^2, d^2 F(c1, c3, \lambda)/(dc3 dc1),}
    \deqn{dg(c1, c3)/dc3, d^2 F(c1, c3, \lambda)/(dc1 dc3), d^2 F(c1, c3, \lambda)/dc3^2), 3, 3, byrow = TRUE)}
    Here, \eqn{F(c1, c3, \lambda) = f(c1, c3) + \lambda * [\gamma_{1} - g(c1, c3)]} is the Fleishman Transformation Lagrangean expression
    (see \code{\link[SimMultiCorrData]{fleish_skurt_check}}).  Headrick & Sawilowsky (2002) gave equations for the second-order derivatives
    \eqn{d^2 F/dc1^2}, \eqn{d^2 F/dc3^2}, and \eqn{d^2 F/(dc1 dc3)}.  These were verified and \eqn{dg/dc1} and \eqn{dg/dc3} were calculated
    using \code{D} (see \code{\link[stats]{deriv}}).  This function would not ordinarily be called by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{fleish_skurt_check}}.
}
\seealso{
\code{\link[SimMultiCorrData]{fleish_skurt_check}}, \code{\link[SimMultiCorrData]{calc_lower_skurt}}
}
\keyword{Fleishman,}
\keyword{Hessian}
\keyword{boundary,}
\keyword{kurtosis,}
