% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIE-package.R
\docType{package}
\name{PIE}
\alias{PIE-package}
\alias{PIE}
\title{PIE: A Partially Interpretable Model with Black-box Refinement}
\description{
The PIE package implements a novel Partially Interpretable Model (PIE) framework
introduced by Wang et al. <arxiv:2105.02410>. This framework jointly train an interpretable model
and a black-box model to achieve high predictive performance as well as partial model transparency.
}
\section{Functions}{

- \code{predict.PIE()}: Main function for generating predictions with the PIE model on dataset.
- \code{PIE()}: Main function for training the PIE model with dataset.
- \code{data_process()}: Process data into the format that can be used by PIE model.
- \code{sparsity_count()}: Counts the number of features used in group lasso.
- \code{RPE()}: Evaluate the RPE of a PIE model.
- \code{MAE()}: Evaluate the MAE of a PIE model.



For more details, see the documentation for individual functions.
}

\author{
\strong{Maintainer}: Jingyi Yang \email{jy4057@stern.nyu.edu}

Authors:
\itemize{
  \item Tong Wang
  \item Yunyi Li
  \item Boxiang Wang
}

}
\keyword{intrepretable-machine-learning}
