% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ConfinableHoming.R
\name{cubeConfinableHoming}
\alias{cubeConfinableHoming}
\title{Inheritance Cube: Confinable Homing}
\usage{
cubeConfinableHoming(
  cF = 1,
  cM = 1,
  chF = 0,
  crF = 0,
  chM = 0,
  crM = 0,
  dR = 0,
  dB = 0,
  crossF = 0,
  crossM = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cF}{Cutting efficiency of drive allele at locus 1 in females}

\item{cM}{Cutting efficiency of drive allele at locus 1 in males}

\item{chF}{Homing efficiency of drive allele at locus 1 in females}

\item{crF}{Resistance allele generation rate at locus 1 in females}

\item{chM}{Homing efficiency of drive allele at locus 1 in males}

\item{crM}{Resistance allele generation rate at locus 1 in males}

\item{dR}{Background mutation rate from W and H into R allele in males and females}

\item{dB}{Background mutation rate from A into B allele in males and females}

\item{crossF}{Female crossover rate}

\item{crossM}{Male crossover rate}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates a confinable homing construct, it has 4 alleles at the first locus
and 3 alleles at the second.
\itemize{
\item W: Wild-type
\item H: Homing allele
\item A: Antidote allele
\item R: No-cost resistance allele
\item B: Detrimental resistance allele
}
}
