% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-lifecycle-network-P.R
\name{spn_P_lifecycle_network}
\alias{spn_P_lifecycle_network}
\title{Make Places (P) For a Network (Mosquitoes only)}
\usage{
spn_P_lifecycle_network(num_nodes, params, cube)
}
\arguments{
\item{num_nodes}{number of nodes in the network}

\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a list with two elements: \code{ix} contains labeled indices of the
places by life stage and node_id, \code{u} is the character vector of places (P)
}
\description{
This function makes the set of places (P) for a SPN model of a metapopulation
network. It is the network version of \code{\link{spn_P_lifecycle_node}}.
}
\details{
The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, and \code{nP} parameters to be specified. For more details, see
\code{\link{equilibrium_lifeycle}}

For examples of using this function, see:
\code{vignette("lifecycle-network", package = "MGDrivE2")}
}
