% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coralGetXDataExt.R
\name{coralGetXDataExt}
\alias{coralGetXDataExt}
\title{coralGetXDataExt}
\usage{
coralGetXDataExt(m, nf = NULL, varProp = NULL)
}
\arguments{
\item{m}{fitted \code{Hmsc}-class object}

\item{nf}{upper number of leading latent factors to be used in CORAL analysis per \code{HmscRandomLevel}}

\item{varProp}{proportion of explanatory variance for selection of the number of leading latent factors}
}
\value{
A named list of extended \code{XDataExt} dataframe and corresponding extended \code{XFormulaExt}
}
\description{
Constructs extended \code{XData} and \code{XFormula} from fitted \code{Hmsc} for consequent CORAL analysis
}
\details{
This functions finds a point estimate of latent factors from fitted \code{m} \code{Hmsc}-class object
and stacks \code{m$XData} and \code{m$XFormula} with this point estimate.
Such point estimate of latent factors is selected among the posterior MCMC samples of the \code{m}, specifically the one with top explanatory power.
The selected posterior sample is potentially truncated to a smaller number of leading latent factors, based on \code{nf} or \code{varProp} arguments.

Only one of \code{nf} and \code{varProp} can be specified.
Each of these arguments can be provided as vector of length \code{m$nr} or scalar value that is broadcasted to such vector.
By default the \code{nf} is set to infinity, resulting in selection of all estimated latent factors.

For example, if \code{Hmsc} model has \code{XFormula="~X1+X2"} and 2 random levels \code{LF1, LF2}, with 3 and 4 latent factors extracted correspondingly,
then the extended \code{XDataExt="~X1+X2 + LF1.1+LF1.2+LF1.3 + LF2.1+LF2.2+LF2.3+LF2.4"}.
}
