% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plotting.R
\name{dot_plot}
\alias{dot_plot}
\title{Dot plots of mean Vortex parameters}
\usage{
dot_plot(
  data,
  project,
  scenario,
  yrs = c(1, 2),
  params = c("PExtinct", "Nextant", "Het", "Nalleles"),
  setcolour = "scen.name",
  plotpops = c("all"),
  save2disk = TRUE,
  dir_out = "Plots"
)
}
\arguments{
\item{data}{A df from \code{collate_dat}}

\item{project}{Vortex project name (used to name the output)}

\item{scenario}{Vortex scenario name (used to name the output)}

\item{yrs}{The years to be included in the plot}

\item{params}{Vortex parameters to be plotted,
default: c('PExtinct', 'Nextant', 'Het', 'Nalleles')}

\item{setcolour}{Variable to be used to set colours of data,
default: scen.name}

\item{plotpops}{The populations to be included in the plot, default: 'all'}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: Plots}
}
\value{
Dot plots of mean parameter values with standard deviation
}
\description{
\code{dot_plot} generates dot plots of mean parameter values for each population
(row) at each year value requested with 'yrs' (columns). Bars represent
standard deviation.
}
\details{
Plots are ggplot objects. When \code{save2disk=TRUE} these are saved as .rda
and .pdf files

\code{yrs} can be a numeric vector of length >= 1 (e.g. \code{yrs=c(50,100)}).
Each point in time will be plotted in different columns.

If a continuous variable is passed to \code{setcolour}, a continuous gradient
of colour will be assigned to the marker (e.g. for example, a scale from blue
to black). If a sharp change of colours between different values of a
continuous variable is desired, it has to be converted into a factor.
}
\examples{
# Using Pacioni et al. example data. See ?pac.clas for more details.
data(pac.clas)
dot <- dot_plot(data=pac.clas, project='Pacioni_et_al', scenario='ST_Classic',
               yrs=c(80, 120),
               params=c('PExtinct', 'Nextant', 'Het', 'Nalleles'),
               save2disk=FALSE)
}
