% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qtl.R
\name{plot_profile}
\alias{plot_profile}
\title{Logarithm of \emph{P}-value (LOP) profile plots. Modified version of QTLpoly function.}
\usage{
plot_profile(
  profile,
  qtl_info,
  selected_mks,
  pheno.col = NULL,
  lgs.id = NULL,
  by_range = TRUE,
  range.min = NULL,
  range.max = NULL,
  plot = TRUE,
  software = NULL
)
}
\arguments{
\item{profile}{data.frame with: pheno - phenotype ID; LOP - significance value for the QTL. 
It can be LOP, LOD or DIC depending of the software used}

\item{qtl_info}{data.frame with: LG - linkage group ID; Pos - position in linkage map (cM); 
Pheno - phenotype ID; Pos_lower - lower position of confidence interval; 
Pos_upper - upper position of the confidence interval; Pval - QTL p-value; h2 - herdability}

\item{selected_mks}{data.frame with: LG - linkage group ID; mk - marker ID; pos - position in linkage map (cM)}

\item{pheno.col}{integer identifying phenotype}

\item{lgs.id}{integer identifying linkage group}

\item{by_range}{logical TRUE/FALSE. If TRUE range.min and range.max will set a colored window in the plot and the other positions will be gray.
If FALSE, range.min and range.max is ignored}

\item{range.min}{position in centimorgan defining the start of the colored window}

\item{range.max}{position in centimorgan defining the end of the colored window}

\item{plot}{logical TRUE/FALSE. If FALSE the function return a data.frame with information for \code{only_plot_profile} function. 
If TRUE, it returns a ggplot graphic.}

\item{software}{character defining which software was used for QTL analysis. Currently support for: QTLpoly, diaQTL and polyqtlR.}
}
\value{
ggplot graphic (if plot == TRUE) or data.frame (if plot == FALSE) with information 
from QTL significance profile
}
\description{
Plots profiled logarithm of score-based \emph{P}-values (LOP) from individual or combined traits.
}
\keyword{internal}
