% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_set_cores}
\alias{umx_set_cores}
\title{umx_set_cores}
\usage{
umx_set_cores(cores = parallel::detectCores(), model = NULL)
}
\arguments{
\item{cores}{number of cores to use (defaults to max - 1 to preserve UI responsiveness)}

\item{model}{an (optional) model to set. If left NULL, the global option is updated.}
}
\value{
- NULL
}
\description{
set the number of cores (threads) used by OpenMx
}
\examples{
library(umx)
manifests = c("mpg", "disp", "gear")
m1 <- mxModel("ind", type = "RAM",
	manifestVars = manifests,
	mxPath(from = manifests, arrows = 2),
	mxPath(from = "one", to = manifests),
	mxData(mtcars[, manifests], type = "raw")
)
oldCores <- umx_get_cores() # get global value
umx_set_cores() # set to default (max)
umx_set_cores(parallel::detectCores() - 1) # set to max - 1
umx_get_cores() # show new value
umx_set_cores(1, m1)  # set m1 useage to 1 core
umx_get_cores(model = m1)  # show new value
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.psyc.virginia.edu}
}
\seealso{
Other Get and set: \code{\link{umx_get_checkpoint}},
  \code{\link{umx_get_cores}},
  \code{\link{umx_get_optimizer}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_optimizer}}
}

