% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{tree_root_node_with_offset}
\alias{tree_root_node_with_offset}
\title{Retrieve an offset root node}
\usage{
tree_root_node_with_offset(x, byte, point)
}
\arguments{
\item{x}{\verb{[tree_sitter_tree]}

A tree.}

\item{byte, point}{\verb{[double(1), tree_sitter_point]}

A byte and point offset combination.}
}
\value{
An offset root node.
}
\description{
\code{tree_root_node_with_offset()} is similar to \code{\link[=tree_root_node]{tree_root_node()}},
but the returned root node's position has been shifted by the given number of
bytes, rows, and columns.

This function allows you to parse a subset of a document with
\code{\link[=parser_parse]{parser_parse()}} as if it were a self-contained document, but then later
access the syntax tree in the coordinate space of the larger document.

Note that the underlying \code{text} within \code{x} is not what you are offsetting
into. Instead, you should assume that the \code{text} you provided to
\code{\link[=parser_parse]{parser_parse()}} already contained the entire subset of the document you care
about, and the offset you are providing is how far into the document the
beginning of \code{text} is.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)

# If `text` was the whole document, you can just use `tree_root_node()`
node <- tree_root_node(tree)

# If `text` represents a subset of the document, use
# `tree_root_node_with_offset()` to be able to get positions in the
# coordinate space of the original document.
byte <- 5
point <- point(5, 0)
node_offset <- tree_root_node_with_offset(tree, byte, point)

# The position of `fn` if you treat `text` as the whole document
node |>
  node_child(1) |>
  node_child(1)

# The position of `fn` if you treat `text` as a subset of a larger document
node_offset |>
  node_child(1) |>
  node_child(1)
\dontshow{\}) # examplesIf}
}
